% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hierclustering.R
\name{plot_hcc}
\alias{plot_hcc}
\title{Plot a hierarchical crime clustering object}
\usage{
plot_hcc(tree, yticks = seq(-2, 8, by = 2), hang = -1, ...)
}
\arguments{
\item{tree}{an object produced from \code{\link{crimeClust_hier}}}

\item{yticks}{the location of the tick marks for log Bayes factors}

\item{hang}{the hang argument of \code{\link{as.dendrogram}}}

\item{\ldots}{other arguments passed to \code{\link{plot.dendrogram}}}
}
\value{
A dendrogram
}
\description{
Similar to \code{\link{plot.dendrogram}}.
}
\details{
This function creates a dendrogram object and then plots it. It
   corrects the y-axis to give the proper values and adds the number of clusters
   if the tree were cut at a particular log Bayes factor.
}
\examples{
# See vignette: "Crime Series Identification and Clustering" for usage.
}
\seealso{
\code{\link{crimeClust_hier}}
}

