% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_schedule.R
\name{sch_title}
\alias{sch_title}
\title{Title}
\usage{
sch_title(sch, new_value)
}
\arguments{
\item{sch}{A schedule object.}

\item{new_value}{A new title.}
}
\value{
\itemize{
\item A schedule object with new title.
\item A title.
}
}
\description{
A title for project identification.
It depends on user of the class. It is used to set or get project's title.
}
\examples{
sch <- sch_new() \%>\%
  sch_add_activities(
    id = c(1L, 2L, 3L, 4L),
    name = c("A", "B", "C", "D"),
    duration = c(3L, 4L, 9L, 1L)
  ) \%>\%
  sch_add_relations(
    from = c(1L, 2L, 2L),
    to   = c(2L, 3L, 4L)
  ) \%>\%
  sch_plan()

sch_title(sch) # empty
sch \%<>\% sch_title("New title")
sch_title(sch)

}
\seealso{
\code{\link[=sch_relations]{sch_relations()}}, \code{\link[=sch_plan]{sch_plan()}}, \code{\link[=sch_new]{sch_new()}},
\code{\link[=sch_validate]{sch_validate()}}, \code{\link[=sch_activities]{sch_activities()}}, \code{\link[=sch_reference]{sch_reference()}},
\code{\link[=sch_duration]{sch_duration()}}.
}
