% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomWalkRepeats.R
\name{sparseRWR}
\alias{sparseRWR}
\title{Perform random walk with repeats on a sparse matrix}
\usage{
sparseRWR(seed_proteins, w, gamma = 0.6, eps = 1e-10, tmax = 1000, norm = TRUE)
}
\arguments{
\item{seed_proteins}{user defined seed proteins}

\item{w}{The adjacency matrix of a given graph in sparse format - dgCMatrix}

\item{gamma}{restart probability}

\item{eps}{maximum allowed difference between the computed probabilities at the steady state}

\item{tmax}{the maximum number of iterations for the RWR}

\item{norm}{if True, w is normalized by dividing each value by the column sum.}
}
\value{
numeric vector, affinity scores for all nodes in graph relative to provided seeds
}
\description{
This function borrows heavily from the RWR function in the RANKS package (cite here)
}
\examples{
# 1) Run Random walk with restarts on a simple matrix
v1 = (c(1,1,1,0))
v2 = c(0,0,0,1)
v3 = c(1,1,1,0)
v4 = c(0,0,0,1)
w = matrix(data = c(v1,v2,v3,v4), ncol = 4, nrow = 4)
sparseRWR(seed_proteins = c(1,3), w = w, norm = TRUE)

# 2) Works just as well on a sparse matrix
v1 = (c(1,1,1,0))
v2 = c(0,0,0,1)
v3 = c(1,1,1,0)
v4 = c(0,0,0,1)
w = matrix(data = c(v1,v2,v3,v4), ncol = 4, nrow = 4)
w = Matrix::Matrix(w, sparse = TRUE)
sparseRWR(seed_proteins = c(1,4), w = w, norm = TRUE)
\donttest{
#3) Sample workflow for use with human protein-protein interaction network
g <- prep_biogrid()
w <- igraph::as_adjacency_matrix(g)
sparseRWR(seed_proteins = c("EGFR", "KRAS"), w = w, norm = TRUE)
}
}
