% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httprequest.R
\name{HttpRequest}
\alias{HttpRequest}
\title{HTTP request object}
\description{
Create HTTP requests
}
\details{
This R6 class doesn't do actual HTTP requests as does
\code{\link[=HttpClient]{HttpClient()}} - it is for building requests to use for async HTTP
requests in \code{\link[=AsyncVaried]{AsyncVaried()}}

Note that you can access HTTP verbs after creating an \code{HttpRequest}
object, just as you can with \code{HttpClient}. See examples for usage.

Also note that when you call HTTP verbs on a \code{HttpRequest} object you
don't need to assign the new object to a variable as the new details
you've added are added to the object itself.

See \code{\link[=HttpClient]{HttpClient()}} for information on parameters.
}
\section{R6 classes}{

This is an R6 class from the package \pkg{R6}. Find out more
about R6 at \url{https://r6.r-lib.org/}. After creating an instance of an R6
class (e.g., \code{x <- HttpClient$new(url = "https://httpbin.org")}) you can
access values and methods on the object \code{x}.
}

\examples{
\dontrun{
x <- HttpRequest$new(url = "https://httpbin.org/get")
## note here how the HTTP method is shown on the first line to the right
x$get()

## assign to a new object to keep the output
z <- x$get()
### get the HTTP method
z$method()

(x <- HttpRequest$new(url = "https://httpbin.org/get")$get())
x$url
x$payload

(x <- HttpRequest$new(url = "https://httpbin.org/post"))
x$post(body = list(foo = "bar"))

HttpRequest$new(
  url = "https://httpbin.org/get",
  headers = list(
    `Content-Type` = "application/json"
  )
)
}

## ------------------------------------------------
## Method `HttpRequest$verb`
## ------------------------------------------------

z <- HttpRequest$new(url = "https://httpbin.org/get")
res <- z$verb('get', query = list(hello = "world"))
res$payload
}
\seealso{
\link{http-headers}, \link{writing-options}

Other async: 
\code{\link{AsyncQueue}},
\code{\link{AsyncVaried}},
\code{\link{Async}}
}
\concept{async}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{url}}{(character) a url}

\item{\code{opts}}{(list) named list of curl options}

\item{\code{proxies}}{a \code{\link[=proxy]{proxy()}} object}

\item{\code{auth}}{an \code{\link[=auth]{auth()}} object}

\item{\code{headers}}{(list) named list of headers, see \link{http-headers}}

\item{\code{handle}}{a \code{\link[=handle]{handle()}}}

\item{\code{progress}}{only supports \code{httr::progress()}, see \link{progress}}

\item{\code{payload}}{resulting payload after request}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HttpRequest-print}{\code{HttpRequest$print()}}
\item \href{#method-HttpRequest-new}{\code{HttpRequest$new()}}
\item \href{#method-HttpRequest-get}{\code{HttpRequest$get()}}
\item \href{#method-HttpRequest-post}{\code{HttpRequest$post()}}
\item \href{#method-HttpRequest-put}{\code{HttpRequest$put()}}
\item \href{#method-HttpRequest-patch}{\code{HttpRequest$patch()}}
\item \href{#method-HttpRequest-delete}{\code{HttpRequest$delete()}}
\item \href{#method-HttpRequest-head}{\code{HttpRequest$head()}}
\item \href{#method-HttpRequest-verb}{\code{HttpRequest$verb()}}
\item \href{#method-HttpRequest-method}{\code{HttpRequest$method()}}
\item \href{#method-HttpRequest-clone}{\code{HttpRequest$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-print"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-print}{}}}
\subsection{Method \code{print()}}{
print method for \code{HttpRequest} objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-new"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{HttpRequest} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$new(url, opts, proxies, auth, headers, handle, progress)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{(character) A url. One of \code{url} or \code{handle} required.}

\item{\code{opts}}{any curl options}

\item{\code{proxies}}{a \code{\link[=proxy]{proxy()}} object}

\item{\code{auth}}{an \code{\link[=auth]{auth()}} object}

\item{\code{headers}}{named list of headers, see \link{http-headers}}

\item{\code{handle}}{a \code{\link[=handle]{handle()}}}

\item{\code{progress}}{only supports \code{httr::progress()}, see \link{progress}}

\item{\code{urls}}{(character) one or more URLs}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{HttpRequest} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-get"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-get}{}}}
\subsection{Method \code{get()}}{
Define a GET request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$get(path = NULL, query = list(), disk = NULL, stream = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-post"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-post}{}}}
\subsection{Method \code{post()}}{
Define a POST request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$post(
  path = NULL,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list}

\item{\code{body}}{body as an R list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-put"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-put}{}}}
\subsection{Method \code{put()}}{
Define a PUT request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$put(
  path = NULL,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list}

\item{\code{body}}{body as an R list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-patch"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-patch}{}}}
\subsection{Method \code{patch()}}{
Define a PATCH request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$patch(
  path = NULL,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list}

\item{\code{body}}{body as an R list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-delete"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-delete}{}}}
\subsection{Method \code{delete()}}{
Define a DELETE request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$delete(
  path = NULL,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "multipart",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{query}}{query terms, as a named list}

\item{\code{body}}{body as an R list}

\item{\code{disk}}{a path to write to. if NULL (default), memory used.
See \code{\link[curl:curl_fetch]{curl::curl_fetch_disk()}} for help.}

\item{\code{stream}}{an R function to determine how to stream data. if
NULL (default), memory used. See \code{\link[curl:curl_fetch]{curl::curl_fetch_stream()}}
for help}

\item{\code{encode}}{one of form, multipart, json, or raw}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-head"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-head}{}}}
\subsection{Method \code{head()}}{
Define a HEAD request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$head(path = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{URL path, appended to the base URL}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-verb"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-verb}{}}}
\subsection{Method \code{verb()}}{
Use an arbitrary HTTP verb supported on this class
Supported verbs: get, post, put, patch, delete, head
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$verb(verb, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verb}}{an HTTP verb supported on this class: get,
post, put, patch, delete, head. Also supports retry.}

\item{\code{...}}{curl options, only those in the acceptable set from
\code{\link[curl:curl_options]{curl::curl_options()}} except the following: httpget, httppost, post,
postfields, postfieldsize, and customrequest}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{z <- HttpRequest$new(url = "https://httpbin.org/get")
res <- z$verb('get', query = list(hello = "world"))
res$payload
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-method"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-method}{}}}
\subsection{Method \code{method()}}{
Get the HTTP method (if defined)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$method()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(character) the HTTP method
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttpRequest-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HttpRequest-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttpRequest$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
