% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folders.R
\name{folder}
\alias{folder}
\alias{folder<-}
\title{Find and move entities to a new folder}
\usage{
folder(x)

folder(x) <- value
}
\arguments{
\item{x}{For \code{folder}, a Variable to find. For folder assignment, a Variable,
selection of variables in a
Dataset, or any other object that can be moved to a folder.}

\item{value}{For assignment, a character "path" to the folder: either a
vector of nested folder names or a single string with nested folders
separated by a delimiter ("/" default)}
}
\value{
\code{folder} returns the parent folder of \code{x}, or \code{NULL} if the \code{x} is the root
level. \verb{folder<-} returns the
\code{x} input, having been moved to the requested location.
}
\description{
Find and move entities to a new folder
}
\examples{
\dontrun{
ds <- loadDataset("Example survey", project = "Studies")
folder(ds$income) <- "Demographics/Economic"
folder(ds$income)
## [1] "Demographics"    "Economic"
}
}
\seealso{
\code{\link[=mv]{mv()}} \code{\link[=cd]{cd()}}
}
