% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{lowest_uc_compatible_SG}
\alias{lowest_uc_compatible_SG}
\title{Space group compatible with given cell}
\usage{
lowest_uc_compatible_SG(uc)
}
\arguments{
\item{uc}{An object of class 'unit_cell'.}
}
\value{
csym An object of class 'cryst_symm', corresponding
             to the selected, lowest symmetry.
}
\description{
This function returns the space group, among those compatible
with the given unit cell, with the lowest symmetry group
number.
}
\details{
A given unit cell is compatible with several symmetries.
For example, a cell with different sides and different
angles, also different from 90 degrees, is compatible with
the triclinic lattice system, which corresponds to space
groups P1 and P -1. A cell with different sides, alpha = 90,
gamma=90 and beta different from 90, is compatible with the
monoclinic lattice system, which corresponds to space groups
from number 3 ("P 1 2 1") to number 15 (C 1 2/c 1"). In the
first case this function returns "P 1", while in the second
case it returns "P 1 2 1".
}
\examples{
# Monoclinic cell
uc <- unit_cell(10,20,15,90,110,90)

# The selected space group is "P 1 2 1"
csym <- lowest_uc_compatible_SG(uc)
print(csym)

}
