% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityfunctions.R
\name{irank}
\alias{irank}
\alias{frank}
\title{Compute ranks from feature values}
\usage{
irank(x, omega = 0, increasing = FALSE, na.rm = FALSE)

frank(x, omega = 0, increasing = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{vector of values to be ranked}

\item{omega}{numeric; numeric value in [0,1], each corresponding to a different definition of the rank; default is \code{0}. See Details.}

\item{increasing}{logical; if \code{TRUE}, then large elements in \code{x} receive a large rank. 
In other words, larger values in \code{x} are lower in ranking. Otherwise, large elements receive small ranks.}

\item{na.rm}{logical; if \code{TRUE}, then \code{NA}'s are removed from \code{x}.
In other case the output for NAs is NA and for other values it's for extreme
possibilities that NA values are actually in first or last positions of ranking.}
}
\value{
vector of the same length as \code{x} containing the ranks
}
\description{
Given estimates of a certain feature for a set of populations,
calculate the integer ranks of populations, i.e. places in ranking done by feature
values. The larger (or smaller) feature value, the higher the place and the lower the integer
rank (lowest, 1, is the best place).
}
\details{
\code{omega} (\eqn{\omega}) value determines, how equal entries in \code{x} should be ranked; 
in other words how to handle ex aequo cases. If there are none, then the parameter 
does not affect the output of this function. 
For example, let's say, that \eqn{n} largest entries in \code{x} are equal.
Those entries could receive (minimum) rank 1 or (maximum) rank \eqn{n} or some value in between.

Suppose, that we want to assign rank to \eqn{n} equal values in an array.
Denote their minimum rank as \eqn{r} and maximum as \eqn{R = r + n - 1}.
Then the assigned rank is an average of 
minimum and maximum rank, weighted by \eqn{\omega}: 
\deqn{r(1-\omega) + R\omega}
}
\section{Functions}{
\itemize{
\item \code{frank()}: Compute fractional ranks

This method returns ranks in form of fractions from [0-1] interval.
Smaller values (closer to 0) indicate higher rank.

}}
\examples{
irank(c(4,3,1,10,7))
irank(c(4,3,1,10,7), omega=1) # equal to previous ranks because there are no ties
irank(c(4,3,1,10,7), omega=0.5) # equal to previous ranks because there are no ties
irank(c(4,4,4,3,1,10,7,7))
irank(c(4,4,4,3,1,10,7,7), omega=1)
irank(c(4,4,4,3,1,10,7,7), omega=0.5) 
frank(c(4,3,1,10,7))
frank(c(4,3,1,10,7), omega=1) # equal to previous ranks because there are no ties
frank(c(4,3,1,10,7), omega=0.5) # mid-ranks, equal to previous ranks because there are no ties
frank(c(4,4,4,3,1,10,7,7))
frank(c(4,4,4,3,1,10,7,7), omega=1)
frank(c(4,4,4,3,1,10,7,7), omega=0.5) # mid-ranks
}
