% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ctrOpenSearchPagesInBrowser}
\alias{ctrOpenSearchPagesInBrowser}
\title{Open advanced search pages of register(s) or execute search in browser}
\usage{
ctrOpenSearchPagesInBrowser(input = "", register = "",
  copyright = FALSE, ...)
}
\arguments{
\item{input}{Show results of search for \code{queryterm} in
browser. To open the browser with a previous search, (register or)
queryterm can be the output of \link{ctrGetQueryUrlFromBrowser} or can be one
row from \link{dbQueryHistory}.}

\item{register}{Register(s) to open. Either "EUCTR" or "CTGOV" or a vector of
both. Default is to open both registers' advanced search pages. To open the
browser with a previous search, the output of ctrGetQueryUrlFromBrowser()
or one row from dbQueryHistory() can be used.}

\item{copyright}{(Optional) If set to \code{TRUE}, opens copyright pages of
register(s).}

\item{...}{Any additional parameter to use with browseURL, which is called by
this function.}
}
\value{
Is always true, invisibly.
}
\description{
Open advanced search pages of register(s) or execute search in browser
}
\examples{
\dontrun{
ctrOpenSearchPagesInBrowser(
 "https://www.clinicaltrialsregister.eu/ctr-search/search?query=cancer")

ctrOpenSearchPagesInBrowser(
 ctrGetQueryUrlFromBrowser())

ctrOpenSearchPagesInBrowser(
 dbQueryHistory())
}

}
