% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrShowOneTrial.R
\name{ctrShowOneTrial}
\alias{ctrShowOneTrial}
\title{Show full structure and all data of a trial}
\usage{
ctrShowOneTrial(identifier = NULL, con = NULL)
}
\arguments{
\item{identifier}{A trial identifier string}

\item{con}{A database connection object, created with
\code{nodbi}. See section `1 - Database connection` in
\link{ctrdata}.}
}
\value{
Invisibly, the trial data for constructing an HTML widget.
}
\description{
If used interactively, the function shows a widget of all data in the trial
as a tree of field names and values. The widget opens in the default browser.
Fields names and values can be search and selected. Selected fields can be
copied to the clipboard for use with function \link{dbGetFieldsIntoDf}.
The trial is retrieved with \link{ctrLoadQueryIntoDb} if no database
\code{con} is provided or if the trial is not in database \code{con}.
For use in a Shiny app, see output and render functions in source code
\ifelse{latex}{\out{
\href{https://github.com/rfhb/ctrdata/blob/master/R/ctrShowOneTrial.R\#L190}{here}}}{
\href{https://github.com/rfhb/ctrdata/blob/master/R/ctrShowOneTrial.R#L190}{here}}.
}
\details{
This is the widget for CTIS trial 2022-501142-30-00:

\if{html}{
  \figure{ctrdata_ctrShowOneTrial.jpg}
}
\if{latex}{
  \out{\begin{center}}\figure{ctrdata_ctrShowOneTrial.jpg}\out{\end{center}}
}
}
\examples{

dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials",
  flags = RSQLite::SQLITE_RO)

# get sample of identifiers of trials in database
sample(dbFindIdsUniqueTrials(con = dbc), 5L)

# all such identifiers work
id <- "2014-003556-31"
id <- "2014-003556-31-SE"
id <- "76463425"
id <- "ISRCTN76463425"
id <- "NCT03431558"
id <- "2022-501142-30-00"

# note these ids also work with
# ctrGetQueryUrl(url = id) and
# ctrLoadQueryIntoDb(queryterm = id, ...)

# show widget for user to explore and search content as well as to
# select fields of interest and to click on "Copy names of selected
# fields to clipboard..." to use them with dbGetFieldsIntoDf()
ctrShowOneTrial(identifier = id, con = dbc)

}
