% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dfTrials2Long}
\alias{dfTrials2Long}
\title{Extract trial information into long format}
\usage{
dfTrials2Long(df)
}
\arguments{
\item{df}{Data frame with colums including
the trial identifier (\code{_id}) and
one or more variables as obtained from
\link{dbGetFieldsIntoDf}}
}
\value{
A data frame with the five columns:
 trial_id, main_id, sub_id, name, value
}
\description{
The function works with procotol- and results-
related information. It converts lists and other
values into individual rows of a long data frame.
From the resulting data frame, values of interest
can then be selected (e.g. select and outcome
and its analysis by number of the measure which
has "Hazard Ratio" in its name).
}
\examples{
\dontrun{
db <- nodbi::src_sqlite(
  collection = "my_collection"
)
df <- dbGetFieldsIntoDf(
  fields = c(
    "clinical_results.outcome_list.outcome"),
  con = db
)
dfTrials2Long(
  df = df
)
}
}
