% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ctStanFit.R
\name{plot.ctStanFit}
\alias{plot.ctStanFit}
\alias{ctStanPlot}
\title{plot.ctStanFit}
\usage{
\method{plot}{ctStanFit}(x, types = "all", wait = TRUE, ...)
}
\arguments{
\item{x}{Fit object from \code{\link{ctStanFit}}.}

\item{types}{Vector of character strings defining which plots to create.
'all' plots all possible types, including: 'regression', 'kalman', 
'priorcheck', 'trace', 'density','intervals'.}

\item{wait}{Logical. Pause between plots?}

\item{...}{Arguments to pass through to the specific plot functions. Bewar of clashes
may occur if types='all'. For details see the specific functions generating each type of plot.}
}
\value{
Nothing. Generates plots.
}
\description{
Plots for ctStanFit objects
}
\details{
This function is just a wrapper calling the necessary functions for plotting - it 
may be simpler in many cases to access those directly. They are:
 \code{\link{ctStanDiscretePars}},\code{\link{ctKalman}},
 \code{\link{ctStanPlotPost}},\code{stan_trace},
 \code{stan_dens},\code{stan_plot}
 rstan offers many plotting possibilities not available here, to use that functionality
 one must simply call the relevant rstan plotting function. Use \code{x$stanfit} as the stan fit object
 (where x is the name of your ctStanFit object). Because a ctStanFit object has many 
 parameters, the additional argument \code{pars=ctStanParnames(x,'pop_')} is recommended.
 This denotes population means, but see \code{\link{ctStanParnames}} for
 other options.
}
\examples{
\donttest{
plot(ctstantestfit,types=c('regression','kalman','priorcheck'), wait=FALSE)
}
}
