% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs-batch.R
\name{get_exposure_product_data_batch}
\alias{get_exposure_product_data_batch}
\title{Retrieve product data for exposure purposes batch}
\usage{
get_exposure_product_data_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = exposure_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{Chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be
given.}
}
\value{
A named list of data.frames, each containing exposure product
data for each input DTXSID.
}
\description{
Retrieve product data for exposure purposes batch
}
\examples{
has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')
# Pull exposure functional use data for multiple chemicals
dtxsid <- c('DTXSID7020182', 'DTXSID2021315')
dtxsid_product_data <- get_exposure_product_data_batch(DTXSID = dtxsid)
}
