% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{codon_optimize}
\alias{codon_optimize}
\title{Optimize codons}
\usage{
codon_optimize(
  seq,
  optimal_codons,
  codon_table = get_codon_table(),
  level = "subfam"
)
}
\arguments{
\item{seq}{DNAString, or an object that can be coerced to a DNAString.}

\item{optimal_codons}{table optimze codons as generated by \code{est_optimal_codons}.}

\item{codon_table}{a table of genetic code derived from \code{get_codon_table} or
\code{create_codon_table}.}

\item{level}{"subfam" (default) or "amino_acid". Optimize codon usage at which level.}
}
\value{
a DNAString of the optimized coding sequence.
}
\description{
\code{codon_optimize} takes a coding sequence (without stop codon) and replace
each codon to the corresponding synonymous optimal codon.
}
\examples{
cf_all <- count_codons(yeast_cds)
optimal_codons <- est_optimal_codons(cf_all)
seq <- 'ATGCTACGA'
codon_optimize(seq, optimal_codons)

}
