% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{cuml_knn_algo_ivfsq}
\alias{cuml_knn_algo_ivfsq}
\title{Build a specification for the "ivfsq" KNN query algorithm.}
\usage{
cuml_knn_algo_ivfsq(
  nlist,
  nprobe,
  qtype = c("QT_8bit", "QT_4bit", "QT_8bit_uniform", "QT_4bit_uniform", "QT_fp16",
    "QT_8bit_direct", "QT_6bit"),
  encode_residual = FALSE
)
}
\arguments{
\item{nlist}{Number of cells to partition dataset into.}

\item{nprobe}{At query time, the number of cells used for approximate nearest
neighbor search.}

\item{qtype}{Quantizer type. Must be one of {"QT_8bit", "QT_4bit",
"QT_8bit_uniform", "QT_4bit_uniform", "QT_fp16", "QT_8bit_direct",
"QT_6bit"}.}

\item{encode_residual}{Whether to encode residuals.}
}
\value{
An object encapsulating all required parameters of the "ivfsq" KNN
  query algorithm.
}
\description{
Build a specification of the inverted-file-scalar-quantization KNN query
algorithm, with all required parameters specified explicitly.
}
