% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm.R
\name{cuml_svm}
\alias{cuml_svm}
\title{Train a SVM model.}
\usage{
cuml_svm(
  x,
  y = NULL,
  formula = NULL,
  mode = c("classification", "regression"),
  cost = 1,
  kernel = c("rbf", "tanh", "polynomial", "linear"),
  gamma = 1/ncol(x),
  coef0 = 0,
  degree = 3L,
  tol = 0.001,
  max_iter = 100L * nrow(x),
  nochange_steps = 1000L,
  cache_size = 1024,
  epsilon = 0.1,
  sample_weights = NULL,
  cuml_log_level = c("off", "critical", "error", "warn", "info", "debug", "trace")
)
}
\arguments{
\item{x}{The input matrix or dataframe. Each data point should be a row
and should consist of numeric values only.}

\item{y}{A numeric vector of desired responses.}

\item{formula}{If 'x' is a dataframe, then a R formula syntax of the form
'<response col> ~ .' or
'<response col> ~ <predictor 1> + <predictor 2> + ...'
may be used to specify the response column and the predictor column(s).}

\item{mode}{Type of task to perform. Should be either "classification" or
"regression".}

\item{cost}{A positive number for the cost of predicting a sample within or
on the wrong side of the margin. Default: 1.}

\item{kernel}{Type of the SVM kernel function (must be one of "rbf", "tanh",
"polynomial", or "linear"). Default: "rbf".}

\item{gamma}{The gamma coefficient (only relevant to polynomial, RBF, and
  tanh kernel functions, see explanations below).
  Default: 1 / (num features).

  The following kernels are implemented:
    - RBF K(x_1, x_2) = exp(-gamma |x_1-x_2|^2)
    - TANH K(x_1, x_2) = tanh(gamma <x_1,x_2> + coef0)
    - POLYNOMIAL K(x_1, x_2) = (gamma <x_1,x_2> + coef0)^degree
    - LINEAR K(x_1,x_2) = <x_1,x_2>,
  where < , > denotes the dot product.}

\item{coef0}{The 0th coefficient (only applicable to polynomial and tanh
  kernel functions, see explanations below). Default: 0.

  The following kernels are implemented:
    - RBF K(x_1, x_2) = exp(-gamma |x_1-x_2|^2)
    - TANH K(x_1, x_2) = tanh(gamma <x_1,x_2> + coef0)
    - POLYNOMIAL K(x_1, x_2) = (gamma <x_1,x_2> + coef0)^degree
    - LINEAR K(x_1,x_2) = <x_1,x_2>,
  where < , > denotes the dot product.}

\item{degree}{Degree of the polynomial kernel function (note: not applicable
  to other kernel types, see explanations below). Default: 3.

  The following kernels are implemented:
    - RBF K(x_1, x_2) = exp(-gamma |x_1-x_2|^2)
    - TANH K(x_1, x_2) = tanh(gamma <x_1,x_2> + coef0)
    - POLYNOMIAL K(x_1, x_2) = (gamma <x_1,x_2> + coef0)^degree
    - LINEAR K(x_1,x_2) = <x_1,x_2>,
  where < , > denotes the dot product.}

\item{tol}{Tolerance to stop fitting. Default: 1e-3.}

\item{max_iter}{Maximum number of outer iterations in SmoSolver.
Default: 100 * (num samples).}

\item{nochange_steps}{Number of steps with no change w.r.t convergence.
Default: 1000.}

\item{cache_size}{Size of kernel cache (MiB) in device memory. Default: 1024.}

\item{epsilon}{Espsilon parameter of the epsilon-SVR model. There is no
penalty for points that are predicted within the epsilon-tube around the
target values. Please note this parameter is only relevant for regression
tasks. Default: 0.1.}

\item{sample_weights}{Optional weight assigned to each input data point.}

\item{cuml_log_level}{Log level within cuML library functions. Must be one of
{"off", "critical", "error", "warn", "info", "debug", "trace"}.
Default: off.}
}
\value{
A Support Vector Machine classifier / regressor object that can be
  used with the 'predict' S3 generic to make predictions on new data points.
}
\description{
Train a Support Vector Machine model for classification or regression tasks.
}
\examples{

library(cuml4r)

model <- cuml_svm(
  iris[1:100,],
  formula = Species ~ .,
  mode = "classification",
  kernel = "rbf"
)

predictions <- predict(model, iris[1:100,])

cat("Iris species predictions: ", predictions, "\n")

model <- cuml_svm(
  mtcars,
  formula = mpg ~ .,
  mode = "regression",
  kernel = "rbf"
)

predictions <- predict(model, mtcars)

cat("MPG predictions:", predictions, "\n")
}
