% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_times}
\alias{set_times}
\title{Set output times}
\usage{
set_times(x, times)
}
\arguments{
\item{x}{vector of \link{scenarios}}

\item{times}{\code{numerical} vector}
}
\value{
Vector of modified \link{scenarios}
}
\description{
Minimum and maximum output times define the simulated period for a scenario.
Simulation results will be returned for each output time, see \code{\link[=simulate]{simulate()}}.
}
\details{
Be aware that output times may be modified by \code{\link[=set_exposure]{set_exposure()}}. Precision of
simulation results may be influenced by chosen output times, see \code{\link[=simulate]{simulate()}}
for more information.
}
\examples{
# Set simulated period to [2,4] with output intervals of length 1
minnow_it \%>\% set_times(c(2,3,4))

# Decrease output interval length to 0.1
minnow_it \%>\% set_times(seq(2, 4, 0.1))
}
\seealso{
\code{\link[=simulate]{simulate()}}
}
