% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvcrand.R, R/cvcrand_package.R
\docType{package}
\name{cvcrand}
\alias{cvcrand}
\alias{cvcrand}
\alias{cvcrand-package}
\title{Constrained randomization for cluster randomized trials}
\usage{
cvcrand(id = NULL, x, categorical = NULL, weight = NULL, n, ntrt,
  cutoff = 0.1, numschemes = NULL, size = 50000, seed = NULL,
  metric = "L2", nosim = FALSE, savedata = NULL, savebscores = NULL)
}
\arguments{
\item{id}{a vector specifying cluster name}

\item{x}{a data frame specifying the cluster-level covariates to balance}

\item{categorical}{a vector specifying categorical (including binary) variables. This can be names of the columns or number indexes of columns. Suppose there are \code{K} categories for a categorical variable, \code{cvcrand} function creates \code{K-1} dummy variables and drops the first level based on the alphanumeric order. If the user wants to specify different level to drop for a categorical variable, the user can create \code{K-1} dummy variables as wished to use before running \code{cvcrand}}

\item{weight}{a vector of user-specified weights for the covariates}

\item{n}{the total number of clusters. It must be a positive integer}

\item{ntrt}{the number of clusters in the treatment arm; must be a positive integer less than \code{n}}

\item{cutoff}{cutoff of distribution of balance scores below which a randomization scheme is sampled. Its default is 0.1, and must be between 0 and 1.}

\item{numschemes}{number of schemes to sample. If specified, it overrides cutoff and it must be a positive integer.}

\item{size}{number of simulated schemes when simulation is invoked. Its default is 50,000, and must be a positive integer.}

\item{seed}{randomization seed. Its default is 12345}

\item{metric}{balance metric to use. Its choices are "L1" and "L2". The default is "L2"}

\item{nosim}{If TRUE, it makes the program enumerate all randomization schemes, regardless of number}

\item{savedata}{the path of the csv file of the constrained randomization space if specified. The first column of the csv data is an indicator variable of the selected randomization scheme. The csv file is needed for clustered permutation test analysis}

\item{savebscores}{the path of the csv file of the vector of balance scores across the entire randomization space if specified. When this option is specified, a histogram is also produced which displays the distribution of all balance scores with a red line on the graph indicating the selected cutoff}
}
\value{
\code{metric} the metric we use

\code{Allocation} the allocation scheme from the constrained randomization

\code{Bscores} the histogram of the B score with respect to the metric

\code{assignment_message} the statement about how many clusters to randomize to the intervention and the control arms respectively

\code{scheme_message} the statement about how to get the whole randomization space of schemes

\code{BL_cut_message} the statement about the benchmark of the constrained space

\code{BLchoice_message} the statement about the selected scheme from constrained randomization

\code{data_BL} the data frame containing the allocation scheme, the id as well as the original covariates' matrix or data frame

\code{BL_result} the descriptive statistics for all the variables in the original covariates' matrix or data frame in the two arms from the selected scheme
}
\description{
cvcrand performs constrained randomization for cluster randomized
trials (CRTs), especially with a small number of clusters. In constrained randomization,
a randomized scheme is randomly sampled from a subset of all possible randomization schemes
based on the value of a balancing criterion proposed by Raab and Butcher (2001) called balance score. And \code{cvcrand} function has two choices of "L1" and "L2" metrics for balance score.

\code{cvcrand} function enumerates all randomization schemes or chooses the unique ones among some simulated randomization schemes as specified by the user.
Some cluster-level "continuous" or "categorical" covariates are then used to calculate the balance scores for the focused schemes. A subset of the randomization schemes is chosen based on user-specified cutoff of certain quantile of balance scores or some fixed number of schemes with the smallest balance scores. \code{cvcrand} function
treats the subset as the constrained space of randomization schemes and samples one scheme from the constrained space as the final chosen scheme.

cvcrand: a package for efficient design and analysis of cluster randomized trials
}
\section{cvcrand functions}{

The cvcrand function performs constrained randomization on cluster randomized trials (CRTs)
The cptest function performs permutation test on the outcome of cluster randomized trials (CRTs)
}

\examples{
Design_result<-cvcrand(id = Dickinson_design$county,
               metric = "L2",
               x = data.frame(Dickinson_design[, -1]),
               n = 16,
               ntrt = 8,
               categorical = c("location", "incomecat"),
               savedata = "dickinson_constrained.csv",
               savebscores = "dickinson_bscores.csv",
               cutoff = 0.1,
               seed = 12345)

}
\references{
Raab, G.M. and Butcher, I., 2001. Balance in cluster randomized trials. Statistics in medicine, 20(3), pp.351-365.

Li, F., Lokhnygina, Y., Murray, D.M., Heagerty, P.J. and DeLong, E.R., 2016. An evaluation of constrained randomization for the design and analysis of group randomized trials. Statistics in medicine, 35(10), pp.1565-1579.
}
\author{
Hengshi Yu <hengshi@umich.edu>, John A. Gallis <john.gallis@duke.edu>, Fan Li <frank.li@duke.edu>, Elizabeth L. Turner <liz.turner@duke.edu>
}
\keyword{cluster}
\keyword{constrained}
\keyword{randomization}
\keyword{randomized}
\keyword{trails,}
