% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predRisk.R
\name{predRisk}
\alias{predRisk}
\title{Output the prediction risks of each method for partial linear functional additive models (PLFAMs)}
\usage{
predRisk(M, nump, numq, a2, a3, nfolds, XX.train, Y.train, XX.pred, Y.pred)
}
\arguments{
\item{M}{The number of candidate models.}

\item{nump}{The number of scalar predictors in candidate models.}

\item{numq}{The number of funtional principal components (FPCs) in candidate models.}

\item{a2}{The number of FPCs in each candidate model. See \code{\link{modelspec}}.}

\item{a3}{The index for each component in each candidate model. See \code{\link{modelspec}}.}

\item{nfolds}{The number of folds used in cross-validation.}

\item{XX.train}{The training data of predictors processed.}

\item{Y.train}{The training data of response variable.}

\item{XX.pred}{The test data of predictors processed.}

\item{Y.pred}{The test data of response variable.}
}
\value{
A \code{list} of
    \item{aic}{Mean squared error risk in training data set, produced by AIC model selection method.}
    \item{bic}{Mean squared error risk in training data set, produced by BIC model selection method.}
    \item{saic}{Mean squared error risk in training data set, produced by SAIC model averaging method.}
    \item{sbic}{Mean squared error risk in training data set, produced by SBIC model averaging method.}
    \item{cv}{Mean squared error risk in training data set, produced by CVMA method.}
    \item{ws}{A \code{list} of weights estimator for five methods.}
    \item{predaic}{Mean squared prediction error risk in test data set, produced by AIC model selection method.}
    \item{predbic}{Mean squared prediction error risk in test data set, produced by BIC model selection method.}
    \item{predsaic}{Mean squared prediction error risk in test data set, produced by SAIC model averaging method.}
    \item{predsbic}{Mean squared prediction error risk in test data set, produced by SBIC model averaging method.}
    \item{predcv}{Mean squared prediction error risk in test data set, produced by CVMA method.}
}
\description{
Calculate the estimated weights for averaging across all candidate models and the corresponding
     mean squared prediction error risk. The methods include AIC, BIC, SAIC, SBIC, and CVMA for PLFAMs.
}
