% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_na_rows.R
\name{drop_na_rows}
\alias{drop_na_rows}
\title{Drop rows that are \code{NA} in all variables.}
\usage{
drop_na_rows(population, variables)
}
\arguments{
\item{population}{tbl with grouping (metadata) and observation variables.}

\item{variables}{character vector specifying observation variables.}
}
\value{
\code{population} without rows that have \code{NA} in all variables.
}
\description{
\code{drop_na_rows} drops rows that are \code{NA} in all variables.
}
\examples{
 population <- tibble::data_frame(
   Metadata_group = c("control", "control", "control", "control",
                      "experiment", "experiment", "experiment", "experiment"),
   Metadata_batch = c("a", "a", "b", "b", "a", "a", "b", "b"),
   AreaShape_Area = c(10, 12, NA, 16, 8, 8, 7, 7),
   AreaShape_Length = c(2, 3, NA, NA, 4, 5, 1, 5)
 )
variables <- c('AreaShape_Area','AreaShape_Length')
drop_na_rows(population, variables)


}
