% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_types.R
\name{field_types}
\alias{field_types}
\title{Create field_types specification}
\usage{
field_types(...)
}
\arguments{
\item{...}{names and types of fields (columns) in source data.}
}
\value{
A \code{field_types} object
}
\description{
Specify the names and types of fields in the source data frame. This is
important because the data in each field will be aggregated in different
ways, depending on its \code{field_type}.  See \link{field_types_available}
}
\examples{
fts <- field_types(
  PatientID = ft_uniqueidentifier(),
  TestID = ft_ignore(),
  TestDate = ft_timepoint(),
  TestName = ft_categorical(aggregate_by_each_category = FALSE),
  TestResult = ft_numeric(),
  ResultDate = ft_datetime(),
  ResultComment = ft_freetext(),
  Location = ft_categorical()
)

fts
}
\seealso{
\code{\link[=field_types_available]{field_types_available()}}, \code{\link[=template_field_types]{template_field_types()}}
}
