% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{report_data}
\alias{report_data}
\title{Generate report from existing objects}
\usage{
report_data(
  source_data,
  aggregated_data,
  report_title = "daiquiri data quality report",
  save_directory = ".",
  save_filename = NULL,
  format = "html",
  show_progress = TRUE,
  ...
)
}
\arguments{
\item{source_data}{A \code{daiquiri_source_data} object returned from
\code{\link[=prepare_data]{prepare_data()}} function}

\item{aggregated_data}{A \code{daiquiri_aggregated_data} object returned from
\code{\link[=aggregate_data]{aggregate_data()}} function}

\item{report_title}{Title to appear on the report}

\item{save_directory}{String specifying directory in which to save the
report. Default is current directory.}

\item{save_filename}{String specifying filename for the report, excluding any
file extension. If no filename is supplied, one will be automatically
generated with the format \code{daiquiri_report_YYMMDD_HHMMSS}.}

\item{format}{File format of the report. Currently only \code{"html"} is supported}

\item{show_progress}{Print progress to console. Default = \code{TRUE}}

\item{...}{Further parameters to be passed to \code{rmarkdown::render()}. Cannot
include any of \code{input}, \code{output_dir}, \code{output_file}, \code{params}, \code{quiet}, \code{intermediates_dir}.}
}
\value{
A string containing the name and path of the saved report
}
\description{
Generate report from previously-created \code{daiquiri_source_data} and
\code{daiquiri_aggregated_data} objects
}
\examples{
\donttest{
# load example data into a data.frame
raw_data <- read_data(
  system.file("extdata", "example_prescriptions.csv", package = "daiquiri"),
  delim = ",",
  col_names = TRUE
)

# validate and prepare the data for aggregation
source_data <- prepare_data(
  raw_data,
  field_types = field_types(
    PrescriptionID = ft_uniqueidentifier(),
    PrescriptionDate = ft_timepoint(),
    AdmissionDate = ft_datetime(includes_time = FALSE),
    Drug = ft_freetext(),
    Dose = ft_numeric(),
    DoseUnit = ft_categorical(),
    PatientID = ft_ignore(),
    Location = ft_categorical(aggregate_by_each_category = TRUE)
  ),
  override_column_names = FALSE,
  na = c("", "NULL"),
  dataset_description = "Example data provided with package",
  show_progress = TRUE
)

# aggregate the data
aggregated_data <- aggregate_data(
  source_data,
  aggregation_timeunit = "day",
  show_progress = TRUE
)

# save a report in the current directory using the previously-created objects
report_data(
  source_data,
  aggregated_data,
  report_title = "daiquiri data quality report",
  save_directory = ".",
  save_filename = "example_data_report",
  show_progress = TRUE
)
\dontshow{file.remove("./example_data_report.html")}
}

}
\seealso{
\code{\link[=prepare_data]{prepare_data()}}, \code{\link[=aggregate_data]{aggregate_data()}},
\code{\link[=daiquiri_report]{daiquiri_report()}}
}
