% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_ma.R
\name{ts_fil_ma}
\alias{ts_fil_ma}
\title{Time Series Moving Average}
\usage{
ts_fil_ma(ma = 3)
}
\arguments{
\item{ma}{moving average size}
}
\value{
a \code{ts_fil_ma} object.
}
\description{
Used to smooth out fluctuations and reduce noise in a time series.
}
\examples{
# time series with noise
data(sin_data)
sin_data$y[9] <- 2*sin_data$y[9]
# convert to sliding windows
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# filter
filter <- ts_fil_ma(3)
filter <- fit(filter, sin_data$y)
y <- transform(filter, sin_data$y)

# plot
plot_ts_pred(y=sin_data$y, yadj=y)
}
