% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_majority.R
\name{cla_majority}
\alias{cla_majority}
\title{Majority Classification}
\usage{
cla_majority(attribute, slevels)
}
\arguments{
\item{attribute}{attribute target to model building.}

\item{slevels}{possible values for the target classification.}
}
\value{
returns a classification object.
}
\description{
This function creates a classification object that uses the majority vote strategy to predict the target attribute. Given a target attribute, the function counts the number of occurrences of each value in the dataset and selects the one that appears most often.
}
\examples{
data(iris)
slevels <- levels(iris$Species)
model <- cla_majority("Species", slevels)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, iris)
train <- sr$train
test <- sr$test

model <- fit(model, train)

prediction <- predict(model, test)
predictand <- adjust_class_label(test[,"Species"])
test_eval <- evaluate(model, predictand, prediction)
test_eval$metrics
}
