% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_incomplete_cases.R
\name{detect_incomplete_cases}
\alias{detect_incomplete_cases}
\title{Detect incomplete cases}
\usage{
detect_incomplete_cases(activitylog, activities, details, filter_condition)
}
\arguments{
\item{activitylog}{The activity log}

\item{activities}{A vector of activity names which should be present for a case}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
tbl_df providing an overview of the traces (i.e. the activities executed for a particular case) in which the specified activities are not present, together with its occurrence frequency and cases having this trace
}
\description{
Function detecting incomplete cases in terms of the activities that need to be recorded for a case. The function only checks the presence of activities, not the completeness of the rows describing the activity executions.
}
\examples{
\donttest{
data("hospital_actlog")
detect_incomplete_cases(activitylog = hospital_actlog,
     activities = c("Registration","Triage","Clinical exam","Treatment","Treatment evaluation"))
}
}
