% Generated by roxygen2 (4.0.2): do not edit by hand
\name{constructWQPURL}
\alias{constructWQPURL}
\title{Construct WQP url for data retrieval}
\usage{
constructWQPURL(siteNumber, parameterCd, startDate, endDate)
}
\arguments{
\item{siteNumber}{string or vector of strings USGS site number.  This is usually an 8 digit number}

\item{parameterCd}{string or vector of USGS parameter code.  This is usually an 5 digit number.}

\item{startDate}{string starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{string ending date for data retrieval in the form YYYY-MM-DD.}
}
\value{
url string
}
\description{
Imports data from WQP web service. This function gets the data from here: \url{http://nwis.waterdata.usgs.gov/nwis/qwdata}
A list of parameter codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/pmcodes/}
A list of statistic codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/help/?read_file=stat&format=table}
}
\examples{
siteNumber <- '01594440'
startDate <- '1985-01-01'
endDate <- ''
pCode <- c("00060","00010")
url_wqp <- constructWQPURL(paste("USGS",siteNumber,sep="-"),
           c('01075','00029','00453'),
           startDate,endDate)
}
\keyword{WQP}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

