% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_sdtm.R
\name{impute_sdtm}
\alias{impute_sdtm}
\title{Imputes Partial Date/Time SDTMv Variables}
\usage{
impute_sdtm(dsin, varin, varout)
}
\arguments{
\item{dsin}{Name of input SDTMv dataframe}

\item{varin}{Name of input SDTMv character date/time variable, which must be in ISO 8601
extended format (YYYY-MM-DDThh:mm:ss). The use of date/time intervals are not permitted.}

\item{varout}{Name of imputed output variable}
}
\value{
Returns the input SDTMv dataframe, with the addition of one extra variable (varout) in
POSIXct datetime format, which is the imputed version of varin.
}
\description{
Imputes partial date/time SDTMv variables, as required by the datacut process.
}
\examples{
ex <- data.frame(
  USUBJID = rep(c("UXYZ123a"), 13),
  EXSTDTC = c(
    "", "2022", "2022-06", "2022-06-23", "2022-06-23T16", "2022-06-23T16:57",
    "2022-06-23T16:57:30", "2022-06-23T16:57:30.123", "2022-06-23T16:-:30",
    "2022-06-23T-:57:30", "2022-06--T16:57:30", "2022---23T16:57:30", "--06-23T16:57:30"
  )
)
ex_imputed <- impute_sdtm(dsin = ex, varin = EXSTDTC, varout = DCUT_TEMP_EXSTDTC)

}
\keyword{derive}
