% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_cut.R
\name{apply_cut}
\alias{apply_cut}
\title{Applies the datacut based on the datacut flagging variables}
\usage{
apply_cut(dsin, dcutvar, dthchangevar)
}
\arguments{
\item{dsin}{Name of input dataframe}

\item{dcutvar}{Name of datacut flagging variable created by \code{pt_cut} and \code{date_cut} functions -
usually called DCUT_TEMP_REMOVE.}

\item{dthchangevar}{Name of death after datacut flagging variable created by \code{special_dm_cut}
function - usually called DCUT_TEMP_DTHCHANGE.}
}
\value{
Returns the input dataframe, excluding any rows in which \code{dcutvar} is flagged as "Y".
DTHDTC and DTHFL are set to missing for any records where \code{dthchangevar} is flagged as "Y". Any
variables with the "DCUT_TEMP" prefix are removed.
}
\description{
Removes any records where the datacut flagging variable, usually called
DCUT_TEMP_REMOVE, is marked as "Y". Also, sets the death related variables in DM
(DTHDTC and DTHFL) to missing if the death after datacut flagging variable, usually
called DCUT_TEMP_DTHCHANGE, is marked as "Y".
}
\examples{
ae <- data.frame(
  USUBJID = c("UXYZ123a", "UXYZ123b", "UXYZ123c", "UXYZ123d"),
  DCUT_TEMP_REMOVE = c("Y", "", "NA", NA)
)
ae_final <- apply_cut(dsin = ae, dcutvar = DCUT_TEMP_REMOVE, dthchangevar = DCUT_TEMP_DTHCHANGE)

dm <- data.frame(
  USUBJID = c("UXYZ123a", "UXYZ123b", "UXYZ123b"),
  DTHDTC = c("2014-10-20", "2014-10-21", "2013-09-08"),
  DTHFL = c("Y", "Y", "Y"),
  DCUT_TEMP_REMOVE = c(NA, NA, "Y"),
  DCUT_TEMP_DTHCHANGE = c(NA, "Y", "")
)
dm_final <- apply_cut(dsin = dm, dcutvar = DCUT_TEMP_REMOVE, dthchangevar = DCUT_TEMP_DTHCHANGE)
}
\keyword{derive}
