% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabla_frecuencia_palabras.R
\name{tabla_frecuencia_palabras}
\alias{tabla_frecuencia_palabras}
\title{Generar una tabla estilizada con las palabras mas frecuentes}
\usage{
tabla_frecuencia_palabras(datos, max_words, stop_words = NULL)
}
\arguments{
\item{datos}{Data frame que contiene la columna 'contenido_limpio'.}

\item{max_words}{Numero maximo de palabras que se mostraran en la tabla.}

\item{stop_words}{Vector opcional de palabras que se deben excluir del conteo.}
}
\value{
Una tabla con las palabras mas frecuentes.
}
\description{
Esta funcion procesa la columna 'contenido_limpio' de un dataframe, tokeniza el texto,
cuenta la frecuencia de cada palabra y genera una tabla con las palabras mas frecuentes.
}
\examples{
datos <- data.frame(
  contenido_limpio = c(
    "La ministra de Defensa Maya Fernandez enfrenta cuestionamientos
    el presidente Gabriel Boric solicita transparencia en los procesos.
    Renovacion Nacional pide la renuncia de Maya Fernandez debido a la polemica.
    La transparencia es fundamental en la politica y la gestion publica"
  ),
  stringsAsFactors = FALSE
)

# Probar la funcion con el dataframe de ejemplo
tabla_frecuencia_palabras(datos, max_words = 5, stop_words = c())
}
