% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-emol-helpers.R
\name{helper_extraer_temas}
\alias{helper_extraer_temas}
\title{Helper para extraer y procesar los temas de datos de Emol}
\usage{
helper_extraer_temas(
  source_seccion,
  source_subseccion,
  source_temas,
  fuente_actual
)
}
\arguments{
\item{source_seccion}{El contenido de la columna `_source.seccion`.}

\item{source_subseccion}{El contenido de la columna `_source.subSeccion`.}

\item{source_temas}{El contenido de la columna `_source.temas`. Puede ser
un dataframe, lista, vector, o NULL.}

\item{fuente_actual}{Un string que indica la fuente (e.g., "mediosregionales").}
}
\value{
Una lista que contiene un unico elemento: un vector de strings (character)
  con los temas procesados y unicos. Si no hay temas, devuelve una lista
  conteniendo un vector de caracteres vacio (`character(0)`).
}
\description{
Esta funcion interna procesa las columnas `_source.seccion`,
`_source.subSeccion` (si aplica), y `_source.temas` de una fila de
datos de Emol para generar una lista de temas procesados.
Los temas se convierten a minusculas y los espacios se reemplazan por guiones.
}
\keyword{internal}
