% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_data.R
\name{show_data}
\alias{show_data}
\title{Display a table in a window}
\usage{
show_data(
  data,
  title = NULL,
  options = NULL,
  show_classes = TRUE,
  type = c("popup", "modal"),
  width = "80\%"
)
}
\arguments{
\item{data}{a data object (either a \code{matrix} or a \code{data.frame}).}

\item{title}{Title to be displayed in window.}

\item{options}{Arguments passed to \code{\link[reactable:reactable]{reactable::reactable()}}.}

\item{show_classes}{Show variables classes under variables names in table header.}

\item{type}{Display table in a pop-up or in modal window.}

\item{width}{Width of the window, only used if \code{type = "popup"}.}
}
\value{
No value.
}
\description{
Display a table in a window
}
\examples{

library(shiny)
library(datamods)

ui <- fluidPage(
  actionButton(
    inputId = "show1",
    label = "Show data in popup",
    icon = icon("eye")
  ),
  actionButton(
    inputId = "show2",
    label = "Show data in modal",
    icon = icon("eye")
  ),
  actionButton(
    inputId = "show3",
    label = "Show data without classes",
    icon = icon("eye")
  )
)

server <- function(input, output, session) {
  observeEvent(input$show1, {
    show_data(mtcars, title = "My data")
  })
  observeEvent(input$show2, {
    show_data(mtcars, title = "My data", type = "modal")
  })
  observeEvent(input$show3, {
    show_data(
      data = mtcars,
      title = "My data",
      show_classes = FALSE,
      options = list(searchable = TRUE, highlight = TRUE)
    )
  })
}

if (interactive())
  shinyApp(ui, server)
}
