% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{createDataPackage}
\alias{createDataPackage}
\alias{createDataPackage,D1Client,DataPackage-method}
\title{Create a DataPackage on a DataONE Member Node}
\usage{
createDataPackage(x, dataPackage, ...)

\S4method{createDataPackage}{D1Client,DataPackage}(x, dataPackage, ...)
}
\arguments{
\item{x}{A D1Client instance.}

\item{dataPackage}{The DataPackage instance to be submitted to DataONE for creation.}

\item{...}{Additional arguments}
}
\value{
The identifier of the uploaded package.
}
\description{
Upload all members of a DataPackage to DataONE.
}
\examples{
\dontrun{
library(dataone)
testdf <- data.frame(x=1:10,y=11:20)
csvfile <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".csv")
write.csv(testdf, csvfile, row.names=FALSE)
d1c <- D1Client("STAGING", "urn:node:mnStageUCSB2")
dp <- new("DataPackage")
emlFile <- system.file("extdata/strix-pacific-northwest.xml", package="dataone")
emlChar <- readLines(emlFile)
emlRaw <- charToRaw(paste(emlChar, collapse="\\n"))
emlId <- sprintf("urn:uuid:\%s", UUIDgenerate())
metadataObj <- new("D1Object", id=emlId, format="eml://ecoinformatics.org/eml-2.1.1", data=emlRaw, 
  mnNodeId=getMNodeId(d1c))
sdf <- read.csv(csvfile)
stf <- charToRaw(convert.csv(d1c, sdf))
sciId <- sprintf("urn:uuid:\%s", UUIDgenerate())
sciObj <- new("D1Object", id=sciId, format="text/csv", data=stf, mnNodeId=getMNodeId(d1c))
dp <- addMember(dp, do=sciObj, mo=metadataObj)
expect_true(is.element(sciObj@dataObject@sysmeta@identifier, getIdentifiers(dp)))
resourceMapId <- createDataPackage(d1c, dp, replicate=TRUE, public=TRUE)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}
