% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNode.R
\docType{methods}
\name{getCapabilities}
\alias{getCapabilities}
\alias{getCapabilities,MNode-method}
\title{Get the node capabilities description, and store the information in the MNode.}
\usage{
getCapabilities(x, ...)

\S4method{getCapabilities}{MNode}(x)
}
\arguments{
\item{x}{The node identifier with which this node is registered in DataONE}

\item{...}{(Not yet used.)}
}
\value{
an XMLInternalDocument object representing the DataONE environment
}
\description{
Access the DataONE getCapabilities() service for the Member Node, which returns an XML
description of the repository and the services it offers.
}
\examples{
\dontrun{
library(dataone)
cn <- CNode()
mn <- getMNode(cn, "urn:node:KNB")
xml <- getCapabilities(mn)
}
}
\seealso{
\url{https://purl.dataone.org/architecture/apis/MN_APIs.html#MN_core.getCapabilities}
}
