% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{addData,DataPackage,D1Object-method}
\alias{addData,DataPackage,D1Object-method}
\title{Add a D1Object containing a data object to a DataPackage}
\usage{
\S4method{addData}{DataPackage,D1Object}(x, do, mo = as.character(NA))
}
\arguments{
\item{x}{The \code{"DataPackage"} to which the data object should be added.}

\item{do}{A D1Object to add to the DataPackage}

\item{mo}{A D1Object (containing metadata describing \code{"do"} ) to associate with the data object.}
}
\description{
The D1Object \code{do} is added to the data package \code{x}.
}
\details{
If the optional \code{mo} parameter is specified, then it is assumed that this DataObject is a metadata
object that describes the data object that is being added. The DataObject specified in the \code{mo} parameter will
also be added to the DataPackage, if it has not already been added. Then the \code{addData} function will add a relationship
to the resource map that indicates that the metadata object describes the science object, using CiTO, the Citation Typing Ontology, 
\code{documents} and \code{isDocumentedBy} relationships.
}
\examples{
\dontrun{
library(dataone)
library(datapack)
library(uuid)
dp <- new("DataPackage")
d1c <- D1Client("STAGING", "urn:node:mnStageUCSB2")
# Create metadata object that describes science data
newId <- sprintf("urn:uuid:\%s", UUIDgenerate())
csvfile <- system.file("extdata/sample.csv", package="dataone")
sciObj <- new("DataObject", id=newId, format="text/csv",filename=csvfile)
dp <- addData(dp, do = sciObj)
}
}
