/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client;

import java.io.IOException;
import org.dataone.client.CNode;
import org.dataone.client.D1Node;
import org.dataone.client.D1Object;
import org.dataone.client.MNode;
import org.dataone.client.types.ObsoletesChain;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.SystemMetadata;

public class D1Client {
    private static CNode cn = null;

    public static CNode getCN(Session session) throws ServiceFailure {
        if (cn == null) {
            String cnUrl = Settings.getConfiguration().getString("D1Client.CN_URL");
            String cnClassName = Settings.getConfiguration().getString("D1Client.cnClassName");
            if (cnClassName != null) {
                try {
                    cn = (CNode)Class.forName(cnClassName).newInstance();
                }
                catch (Exception e) {
                    throw D1Node.recastClientSideExceptionToServiceFailure(e);
                }
                cn.setNodeBaseServiceUrl(cnUrl);
            } else {
                cn = new CNode(cnUrl, session);
            }
        }
        return cn;
    }

    public static CNode getCN() throws ServiceFailure {
        return D1Client.getCN(null);
    }

    public static MNode getMN(String mnBaseUrl) {
        MNode mn = new MNode(mnBaseUrl);
        return mn;
    }

    public static MNode getMN(NodeReference nodeRef) throws ServiceFailure {
        CNode cn;
        try {
            cn = D1Client.getCN();
        }
        catch (Exception e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        String mnBaseUrl = null;
        try {
            mnBaseUrl = cn.lookupNodeBaseUrl(nodeRef.getValue());
            if (mnBaseUrl == null) {
                throw new ServiceFailure("0000", "Failed to find baseUrl for node " + nodeRef.getValue() + " in the NodeList");
            }
        }
        catch (NotImplemented e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        MNode mn = new MNode(mnBaseUrl);
        return mn;
    }

    public static Identifier create(Session session, D1Object d1object) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        Identifier rGuid;
        SystemMetadata sysmeta = d1object.getSystemMetadata();
        if (sysmeta == null) {
            throw new InvalidRequest("Client Error", "systemMetadata of the D1Object cannot be null");
        }
        String mn_url = D1Client.getCN().lookupNodeBaseUrl(sysmeta.getOriginMemberNode().getValue());
        MNode mn = D1Client.getMN(mn_url);
        try {
            rGuid = mn.create(session, sysmeta.getIdentifier(), d1object.getDataSource().getInputStream(), sysmeta);
        }
        catch (IOException e) {
            throw new ServiceFailure("000 Client Exception", "Could not open InputStream from the data: " + e.getMessage());
        }
        return rGuid;
    }

    public static Identifier update(Session session, D1Object d1object) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest, NotFound {
        Identifier rGuid;
        SystemMetadata sysmeta = d1object.getSystemMetadata();
        if (sysmeta == null) {
            throw new InvalidRequest("Client Error", "systemMetadata of the D1Object cannot be null");
        }
        String mn_url = D1Client.getCN().lookupNodeBaseUrl(sysmeta.getOriginMemberNode().getValue());
        MNode mn = D1Client.getMN(mn_url);
        try {
            rGuid = mn.update(sysmeta.getObsoletes(), d1object.getDataSource().getInputStream(), sysmeta.getIdentifier(), sysmeta);
        }
        catch (IOException e) {
            throw new ServiceFailure("000 Client Exception", "Could not open InputStream from the data: " + e.getMessage());
        }
        return rGuid;
    }

    public static Identifier archive(Session session, D1Object d1object) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        SystemMetadata sysmeta = d1object.getSystemMetadata();
        if (sysmeta == null) {
            throw new InvalidRequest("Client Error", "systemMetadata of the D1Object cannot be null");
        }
        String mn_url = D1Client.getCN().lookupNodeBaseUrl(sysmeta.getAuthoritativeMemberNode().getValue());
        MNode mn = D1Client.getMN(mn_url);
        Identifier rGuid = mn.archive(d1object.getIdentifier());
        return rGuid;
    }

    public static ObsoletesChain listUpdateHistory(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        Identifier startingPid = pid;
        ObsoletesChain chain = new ObsoletesChain(startingPid);
        SystemMetadata smd = null;
        try {
            smd = D1Client.getCN().getSystemMetadata(startingPid, true);
            chain.addObject(pid, smd.getDateUploaded(), smd.getObsoletes(), smd.getObsoletedBy(), smd.getArchived());
            Identifier fpid = smd.getObsoletedBy();
            Identifier bpid = smd.getObsoletes();
            while (fpid != null) {
                smd = D1Client.getCN().getSystemMetadata(fpid, true);
                chain.addObject(fpid, smd.getDateUploaded(), smd.getObsoletes(), smd.getObsoletedBy(), smd.getArchived());
                fpid = smd.getObsoletedBy();
            }
            while (bpid != null) {
                smd = D1Client.getCN().getSystemMetadata(bpid, true);
                chain.addObject(bpid, smd.getDateUploaded(), smd.getObsoletes(), smd.getObsoletedBy(), smd.getArchived());
                bpid = smd.getObsoletes();
            }
        }
        catch (NullPointerException npe) {
            ServiceFailure sf = new ServiceFailure("0000", "Likely Null value for required systemMetadata field for: " + smd.getIdentifier() + npe.getMessage());
            sf.setStackTrace(npe.getStackTrace());
            throw sf;
        }
        return chain;
    }
}

