% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_datapackage.R
\name{new_datapackage}
\alias{new_datapackage}
\title{Create a new Data Package}
\usage{
new_datapackage(path, name = NULL, title = NULL, description = NULL, ...)
}
\arguments{
\item{path}{The directory which will contain the Data Package or the filename
in which to write the Data Package.}

\item{name}{The name of the Data Package.}

\item{title}{The title of the Data Package.}

\item{description}{The description of the Data Package.}

\item{...}{Ignored for now.}
}
\value{
The directory of \code{path}, or the directory containing \code{path} if path
is a file name, is created and the file with the Data Package information is
created. When \code{path} is a directory a file \code{datapackage.json} is
created. The function returns an editable \code{datapackage} object.
}
\description{
Create a new Data Package
}
\examples{
dir <- tempdir()
dp <- new_datapackage(dir, name = "test-package")

dp_title(dp) <- "A Test Data Package"
dp_add_contributor(dp) <- new_contributor(title = "John Doe")

\dontshow{
file.remove(file.path(dir, "datapackage.json"))
file.remove(dir)
}

}
