% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C3FURV.R
\name{duplicate_times}
\alias{duplicate_times}
\title{Duplicate times test}
\usage{
duplicate_times(subdailydata, meta = NULL, outpath)
}
\arguments{
\item{subdailydata}{A character string giving the path of the input file,
or a 7-column matrix with following columns: variable code, year, month,
day, hour, minute, value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{subdailydata} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}
}
\description{
Flag times that appear more than once.
}
\details{
The input file must follow the Copernicus Station Exchange Format (SEF).
}
\examples{
duplicate_times(Bern$p, Meta$p[which(Meta$p$id=="Bern"),], outpath = tempdir())

}
\author{
Alba Gilabert, Yuri Brugnara
}
