% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComplianceDocumentation.R
\name{UpdateComplianceDocTemplate}
\alias{UpdateComplianceDocTemplate}
\title{Update the name or sections of an existing doc template.}
\usage{
UpdateComplianceDocTemplate(templateId, name = NULL, sections = NULL)
}
\arguments{
\item{templateId}{character. The ID of the template to update.}

\item{name}{character. Optional. A new name to identify the compliance doc template by.}

\item{sections}{list. Optional. Section definitions for the compliance template.}
}
\value{
The updated compliance doc template object.
}
\description{
Note that default templates cannot be updated.
}
\examples{
\dontrun{
sections <- list(list("title" = "Missing Values Report",
                      "highlightedText" = "NOTICE",
                      "regularText" = paste("This dataset had a lot of Missing Values."
                                            "See the chart below: {{missingValues}}"),
                      "type" = "user"),
                 list("title" = "Blueprints",
                      "regularText" = "{{blueprintDiagram}} /n Blueprint for this model",
                      "type" = "user"))
  templateId <- "5cf85080d9436e5c310c796d"
  UpdateComplianceDocTemplate(templateId, name = "newName", sections = sections)
}
}
