% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StartAutopilot.R
\name{StartNewAutoPilot}
\alias{StartNewAutoPilot}
\title{Starts autopilot on provided featurelist.
Only one autopilot can be running at the time.
That's why any ongoing autopilot on different featurelist will
be halted - modelling jobs in queue would not
be affected but new jobs would not be added to queue by
halted autopilot.}
\usage{
StartNewAutoPilot(project, featurelistId, mode = AutopilotMode$FullAuto)
}
\arguments{
\item{project}{Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this identifier.}

\item{featurelistId}{Specifies which feature list to use.}

\item{mode}{The desired autopilot mode: either AutopilotMode$FullAuto (default) or
AutopilotMode$SemiAuto (SemiAuto is deprecated in 2.3, will be removed in 3.0)}
}
\description{
There is an error if autopilot is currently running on or has already
finished running on the provided featurelist and also if project's target was not selected
(via SetTarget).
}
