% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{GetModelParameters}
\alias{GetModelParameters}
\title{Retrieve model parameters}
\usage{
GetModelParameters(project, modelId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{character. Unique alphanumeric identifier for the model of interest.}
}
\value{
List with the following components:
\itemize{
  \item parameters. List of model parameters that are related to the whole model with following
    components: name, value.
  \item derivedFeatures. List containing preprocessing information about derived features with
    following components: originalFeature, derivedFeature, type, coefficient, transformations
    and stageCoefficients. `transformations` is a list itself with components: name and value.
    `stageCoefficients` is also a list with components: stage and coefficient. It contains
    coefficients for each stage of multistage models and is empty list for single stage models.
}
}
\description{
Retrieve model parameters
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  GetModelParameters(projectId, modelId)
}
}
