% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eml_to_spice.R
\name{eml_to_spice}
\alias{eml_to_spice}
\title{Create dataspice metadata tables from EML}
\usage{
eml_to_spice(eml, path = NULL)
}
\arguments{
\item{eml}{(emld) An EML object}

\item{path}{(character) Folder path for saving the tables to disk}
}
\value{
A list with names \code{attributes}, \code{access}, \code{biblio}, and \code{creators}.
Optionally, if \code{path} is specified, saves the four tables as \code{CSV} files.
}
\description{
Create dataspice metadata tables from EML
}
\examples{
\dontrun{
# First, load up an example EML record
library(EML)

eml_path <- system.file(
 file.path("example-dataset", "broodTable_metadata.xml"),
 package = "dataspice")
eml <- read_eml(eml_path)


# Generate the four dataspice tables
my_spice <- eml_to_spice(eml)

# Or save them to disd
# Generate the four dataspice tables
eml_to_spice(eml, ".")
}
}
