% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\alias{normalize.numeric}
\alias{normalize.data.frame}
\title{Normalize numeric variable to 0-1 range}
\usage{
normalize(x, ...)

\method{normalize}{numeric}(x, include_bounds = TRUE, verbose = TRUE, ...)

\method{normalize}{data.frame}(
  x,
  include_bounds = TRUE,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric vector, (grouped) data frame, or matrix. See 'Details'.}

\item{...}{Arguments passed to or from other methods.}

\item{include_bounds}{Logical, if \code{TRUE}, return value may include 0 and 1.
If \code{FALSE}, the return value is compressed, using Smithson and Verkuilen's
(2006) formula \code{(x * (n - 1) + 0.5) / n}, to avoid zeros and ones in the
normalized variables. This can be useful in case of beta-regression, where
the response variable is not allowed to include zeros and ones.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item or one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")}.
}

If \code{NULL}, selects all columns.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}
}
\value{
A normalized object.
}
\description{
Performs a normalization of data, i.e., it scales variables in the range 0 -
\enumerate{
\item This is a special case of \code{\link[=data_rescale]{data_rescale()}}.
}
}
\details{
\itemize{
\item If \code{x} is a matrix, normalization is performed across all values (not
column- or row-wise). For column-wise normalization, convert the matrix to a
data.frame.
\item If \code{x} is a grouped data frame (\code{grouped_df}), normalization is performed
separately for each group.
}
}
\examples{

normalize(c(0, 1, 5, -5, -2))
normalize(c(0, 1, 5, -5, -2), include_bounds = FALSE)

head(normalize(trees))

}
\references{
Smithson M, Verkuilen J (2006). A Better Lemon Squeezer? Maximum-Likelihood
Regression with Beta-Distributed Dependent Variables. Psychological Methods,
11(1), 54–71.
}
\seealso{
Other transform utilities: 
\code{\link{data_rescale}()},
\code{\link{data_reverse}()},
\code{\link{ranktransform}()},
\code{\link{standardize}()}
}
\concept{transform utilities}
