% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_check.R
\name{complete_check}
\alias{complete_check}
\title{Complete Check}
\usage{
complete_check(
  DD_dict,
  DS_data,
  non.NA.missing.codes = NA,
  reorder.dict = FALSE,
  name.correct = FALSE
)
}
\arguments{
\item{DD_dict}{Data dictionary.}

\item{DS_data}{Data set.}

\item{non.NA.missing.codes}{A user-defined vector of encoded, numerical (i.e., non-NA) missing value codes (e.g., -9999).}

\item{reorder.dict}{When TRUE, and only if the names between the data and data dictionary match perfectly but are in the wrong order, the function will reorder the rows of the dictionary to match the columns of the data; note please use with caution: we recommend first running the function with the default set to FALSE to understand potential errors.}

\item{name.correct}{When TRUE, if name mismatches are identified, the function will rename the variable names in the data set to match the data dictionary; note please use with caution: we recommend first running the function with the default set to FALSE to identify order/dimension mismatches (vs. name mismatches).}
}
\value{
Tibble containing the following information for each check: (1) Time (time stamp); (2) Name (name of the function); (3) Status (Passed/Failed/Warning); (4) Message (A copy of the message the function printed out); (5) Information (More detailed information about the potential errors identified).
}
\description{
This function runs a full workflow check including \code{field_check}, \code{pkg_field_check}, \code{dimension_check}, \code{name_check}, \code{id_check}, \code{row_check}, \code{NA_check}, \code{type_check}, \code{values_check}, \code{integer_check}, \code{decimal_check}, \code{misc_format_check},  \code{description_check}, \code{minmax_check}, and \code{missing_value_check}.
}
\examples{
# Example 1
# Note in this example, the missing value codes are not defined,
# so the last check ('missing_value_check') doesn't know to
# to check for encoded values
data(ExampleB)
complete_check(DD.dict.B, DS.data.B)
# Rerun check after defining missing value codes
complete_check(DD.dict.B, DS.data.B, non.NA.missing.codes=c(-9999, -4444))

# Example 2
data(ExampleA)
complete_check(DD.dict.A, DS.data.A, non.NA.missing.codes=c(-9999, -4444))

# Example 3
data(ExampleD)
results <- complete_check(DD.dict.D, DS.data.D, non.NA.missing.codes=c(-9999, -4444))  
# View output in greater detail
results$Message[2] # Recommend using add_missing_fields
results$Information$pkg_field_check.Info # We see that MIN, MAX, and TYPE are all missing
# Use the add_missing_fields function to add in data
DD.dict.updated <- add_missing_fields(DD.dict.D, DS.data.D)
# Be sure to call in the new version of the dictionary (DD.dict.updated)
complete_check(DD.dict.updated, DS.data.D)
}
\seealso{
\code{\link{check_report}}
}
