% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog.R
\name{dbi.catalog}
\alias{dbi.catalog}
\title{Create a \code{dbi.catalog}}
\usage{
dbi.catalog(conn)
}
\arguments{
\item{conn}{a connection handle returned by \code{\link[DBI]{dbConnect}} or a
zero-argument function that returns a connection handle.}
}
\value{
\code{dbi.catalog} returns a \code{dbi.catalog} (internally an
        \code{\link[base]{environment}} with the class attribute set to
        \code{"dbi.catalog"}).
}
\description{
A \code{dbi.catalog} represents a database catalog.
}
\examples{
# chinook.duckdb is a zero-argument function that returns a DBI handle
(db <- dbi.catalog(chinook.duckdb))

# a dbi.catalog corresponds to a catalog - list the schemas
ls(db)

# list the tables in the schema 'main'
ls(db$main)

}
