% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cett_general_information_parsers.R
\name{cett_doc}
\alias{cett_doc}
\alias{carriers}
\alias{enzymes}
\alias{targets}
\alias{transporters}
\title{Carriers/ Enzymes/ Targets/ Transporters parsers}
\usage{
carriers(
  save_table = FALSE,
  save_csv = FALSE,
  csv_path = ".",
  override_csv = FALSE,
  database_connection = NULL
)

enzymes(
  save_table = FALSE,
  save_csv = FALSE,
  csv_path = ".",
  override_csv = FALSE,
  database_connection = NULL
)

targets(
  save_table = FALSE,
  save_csv = FALSE,
  csv_path = ".",
  override_csv = FALSE,
  database_connection = NULL
)

transporters(
  save_table = FALSE,
  save_csv = FALSE,
  csv_path = ".",
  override_csv = FALSE,
  database_connection = NULL
)
}
\arguments{
\item{save_table}{boolean, save table in database if true.}

\item{save_csv}{boolean, save csv version of parsed tibble if true}

\item{csv_path}{location to save csv files into it, default is current
location, save_csv must be true}

\item{override_csv}{override existing csv, if any, in case it is true in the
new parse operation}

\item{database_connection}{DBI connection object that holds a connection to
user defined database. If \code{save_table} is enabled without providing
value for this function an error will be thrown.}
}
\value{
a tibble with 6 variables (8 for enzymes):
\describe{
  \item{id}{Universal Protein Resource (UniProt) Identifier for the record}
  \item{name}{related name}
  \item{organism}{Organism that the protein comes from.}
  \item{known_action}{Whether the pharmacological action of the drug is due
   to this target interaction.}
  \item{inhibition-strength}{Whether the strength of enzyme inhibition is
  strong, moderate, or unknown. \strong{Only applies to enzymes}}
  \item{induction-strength}{Whether the strength of enzyme induction is
  strong or unknown. \strong{Only applies to enzymes}}
  \item{position}{related position}
  \item{parent_id}{drugbank id}
}
}
\description{
Protein targets of drug action, enzymes that are inhibited/induced or
involved in metabolism, and carrier or transporter proteins involved in
movement of the drug across biological membranes.
}
\section{read_drugbank_xml_db}{

\code{\link{read_drugbank_xml_db}} function must be called first before any
parser.

If \code{\link{read_drugbank_xml_db}} is called before for any reason, so
no need to call it again before calling this function.
}

\examples{
\dontrun{
# the same parameters and usage will be applied for any parser
# return only the parsed tibble
run_all_parsers()

# will throw an error, as database_connection is NULL
run_all_parsers(save_table = TRUE)

# save in database in SQLite in memory database and return parsed tibble
sqlite_con <- DBI::dbConnect(RSQLite::SQLite())
run_all_parsers(save_table = TRUE, database_connection = sqlite_con)

# save parsed tibble as csv if it does not exist in current location,
# and return parsed tibble.
# if the csv exist before read it and return its data.
run_all_parsers(save_csv = TRUE)

# save in database, save parsed tibble as csv,
# if it does not exist in current location and return parsed tibble.
# if the csv exist before read it and return its data.
run_all_parsers(save_table = TRUE, save_csv = TRUE,
database_connection = sqlite_con)

# save parsed tibble as csv if it does not exist in given location,
# and return parsed tibble.
# if the csv exist before read it and return its data.
run_all_parsers(save_csv = TRUE, csv_path = TRUE)

# save parsed tibble as csv if it does not exist in current location and
# return parsed tibble.
# if the csv exist override it and return it.
run_all_parsers(save_csv = TRUE, csv_path = TRUE, override = TRUE)
}
}
\seealso{
Other cett: 
\code{\link{cett_actions_doc}},
\code{\link{cett_ex_identity_doc}},
\code{\link{cett_go_doc}},
\code{\link{cett_poly_doc}},
\code{\link{cett_poly_pfms_doc}},
\code{\link{cett_poly_syn_doc}}
}
\concept{cett}
