% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-arrange.R
\name{arrange.tbl_lazy}
\alias{arrange.tbl_lazy}
\title{Arrange rows by variables in a remote database table}
\usage{
\method{arrange}{tbl_lazy}(.data, ..., .by_group = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{Variables, or functions or variables. Use desc() to sort a
variable in descending order.}

\item{.by_group}{If \code{TRUE}, will sort first by grouping variable. Applies to
grouped data frames only.}
}
\value{
An object of the same class as \code{.data}.
}
\description{
Order rows of database tables by an expression involving its variables.
}
\section{Missing values}{

Compared to its sorting behaviour on local data, the \code{\link[=arrange]{arrange()}} method for
most database tables sorts NA at the beginning unless wrapped with \code{\link[=desc]{desc()}}.
Users can override this behaviour by explicitly sorting on \code{is.na(x)}.
}

\examples{
library(dplyr)

dbplyr::memdb_frame(a = c(3, 4, 1, 2)) \%>\%
  arrange(a)

# NA sorted first
dbplyr::memdb_frame(a = c(3, 4, NA, 2)) \%>\%
  arrange(a)

# override by sorting on is.na() first
dbplyr::memdb_frame(a = c(3, 4, NA, 2)) \%>\%
  arrange(is.na(a), a)

}
