/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Configuration {
    private List<Double> aaMass = new ArrayList<Double>();
    private List<Double> aaMassDividedTwo = new ArrayList<Double>();
    private List<Double> aaMassDividedThree = new ArrayList<Double>();
    private double minimum = 0.0;
    private double maximum = Double.MAX_VALUE;
    private double F1 = 0.8;
    private double F2 = 0.5;
    private double F3 = 0.1;
    private double F4 = 0.1;
    private double F5 = 0.1;
    private double distance = 1.003;
    private double errortolerance = 0.3;
    private double delta = 0.003;
    private double noise = 0.0;
    private boolean decharge = false;
    private String modus = "first";
    private final double H_MASS = 1.008;
    private final double NH3_MASS = 17.03052;
    private final double H2O_MASS = 18.01528;
    private final double NH_MASS = 15.01464;
    private final double CO_MASS = 28.0101;
    private final double PHE_MASS = 165.192;
    private final double ASP_MASS = 133.104;
    private final double AVE_UPDATED_MASS = 111.125;
    private final double H_MASS_MULTIPLIED_TWO = 2.016;
    private final double H2O_MASS_DIVIDED_TWO = 9.00764;
    private final double H2O_MASS_DIVIDED_THREE = 6.005093333333334;
    private final double NH3_MASS_DIVIDED_TWO = 8.51526;
    private final double NH3_MASS_DIVIDED_THREE = 5.676839999999999;
    private final double NH_MASS_DIVIDED_TWO = 7.50732;
    private final double NH_MASS_DIVIDED_THREE = 7.50732;
    private final double CO_MASS_DIVIDED_TWO = 14.00505;
    private final double CO_MASS_DIVIDED_THREE = 9.3367;

    public boolean isDecharge() {
        return this.decharge;
    }

    public String getModus() {
        return this.modus;
    }

    public double getErrortolerance() {
        return this.errortolerance;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getNoise() {
        return this.noise;
    }

    public double getNH_MASS_DIVIDED_TWO() {
        return 7.50732;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getF1() {
        return this.F1;
    }

    public double getF2() {
        return this.F2;
    }

    public double getF3() {
        return this.F3;
    }

    public double getF4() {
        return this.F4;
    }

    public double getF5() {
        return this.F5;
    }

    public double getNH_MASS_DIVIDED_THREE() {
        return 7.50732;
    }

    public double getCO_MASS_DIVIDED_TWO() {
        return 14.00505;
    }

    public double getCO_MASS_DIVIDED_THREE() {
        return 9.3367;
    }

    public double getH2O_MASS_DIVIDED_TWO() {
        return 9.00764;
    }

    public double getH2O_MASS_DIVIDED_THREE() {
        return 6.005093333333334;
    }

    public double getNH3_MASS_DIVIDED_TWO() {
        return 8.51526;
    }

    public double getNH3_MASS_DIVIDED_THREE() {
        return 5.676839999999999;
    }

    public double getH_MASS_MULTIPLIED_TWO() {
        return 2.016;
    }

    public double getH_MASS() {
        return 1.008;
    }

    public double getNH3_MASS() {
        return 17.03052;
    }

    public double getH2O_MASS() {
        return 18.01528;
    }

    public double getNH_MASS() {
        return 15.01464;
    }

    public double getCO_MASS() {
        return 28.0101;
    }

    public double getPHE_MASS() {
        return 165.192;
    }

    public double getASP_MASS() {
        return 133.104;
    }

    public double getAVE_UPDATED_MASS() {
        return 111.125;
    }

    public double getMin() {
        return this.minimum;
    }

    public double getMax() {
        return this.maximum;
    }

    public List<Double> getAaMass() {
        return this.aaMass;
    }

    public List<Double> getAaMassDividedTwo() {
        return this.aaMassDividedTwo;
    }

    public List<Double> getAaMassDividedThree() {
        return this.aaMassDividedThree;
    }

    public Configuration() {
        this(Arrays.asList(71.03711, 156.10111, 114.04293, 115.02694, 103.00919, 129.04259, 128.05858, 57.02146, 137.05891, 113.08406, 113.08406, 128.09496, 131.04049, 147.06841, 97.05276, 87.03203, 101.04768, 186.07931, 163.06333, 99.06841), 0.8, 0.5, 0.1, 0.1, 0.1, 0.003, 0.3, 1.003, 0.0, false, "first");
    }

    public Configuration(double F1, double F2, double F3, double F4, double F5, double delta, double errortolerance, double distance, double noise, boolean decharge, String modus) {
        this(Arrays.asList(71.03711, 156.10111, 114.04293, 115.02694, 103.00919, 129.04259, 128.05858, 57.02146, 137.05891, 113.08406, 113.08406, 128.09496, 131.04049, 147.06841, 97.05276, 87.03203, 101.04768, 186.07931, 163.06333, 99.06841), F1, F2, F3, F4, F5, delta, errortolerance, distance, noise, decharge, modus);
    }

    public Configuration(List<Double> aaMass, double F1, double F2, double F3, double F4, double F5, double delta, double errortolerance, double distance, double noise, boolean decharge, String modus) {
        this.F1 = F1;
        this.F2 = F2;
        this.F3 = F3;
        this.F4 = F4;
        this.F5 = F5;
        this.delta = delta;
        this.errortolerance = errortolerance;
        this.distance = distance;
        this.noise = noise;
        this.decharge = decharge;
        this.aaMass = aaMass;
        this.modus = modus;
        for (Double x : this.aaMass) {
            this.aaMassDividedTwo.add(x / 2.0);
            this.aaMassDividedThree.add(x / 3.0);
        }
        this.minimum = Collections.min(this.aaMassDividedThree);
        this.maximum = Collections.max(this.aaMass);
    }

    public String toString() {
        return "Configuration,Value\nF1," + this.F1 + "\nF2," + this.F2 + "\nF3," + this.F3 + "\nF4," + this.F4 + "\nF5," + this.F5 + "\nDistance," + this.distance + "\nErrortolerance," + this.errortolerance + "\nDelta," + this.delta + "\nNoise," + this.noise + "\nDecharge," + this.decharge + "\nModus," + this.modus + "\nH Mass," + 1.008 + "\nNH3 Mass," + 17.03052 + "\nH2O Mass," + 18.01528 + "\nNH Mass," + 15.01464 + "\nCO Mass," + 28.0101 + "\nPhenylalanine Mass," + 165.192 + "\nAspartic Acid Mass," + 133.104 + "\nUpdated Averagine Mass," + 111.125 + "\nAmino Acid Masses," + this.print(this.aaMass);
    }

    private String print(List<Double> aaMass) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("[");
        for (Double d : aaMass) {
            stringbuilder.append(d).append(" ");
        }
        stringbuilder.append(" ]");
        return stringbuilder.toString();
    }
}

