/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.mgf;

import ch.fgcz.proteomics.dto.MassSpecMeasure;
import ch.fgcz.proteomics.dto.MassSpecMeasureSerializer;
import ch.fgcz.proteomics.dto.MassSpectrum;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WriteMGF {
    private static final Logger LOGGER = Logger.getLogger(MassSpecMeasureSerializer.class.getName());

    private WriteMGF() {
        throw new IllegalStateException("Writer class");
    }

    public static void write(String fileName, MassSpecMeasure massSpectrometryMeasurement) {
        File f = new File(fileName);
        WriteMGF.writeConnect(f, massSpectrometryMeasurement);
    }

    private static void writeHeader(File fileName, MassSpecMeasure massSpectrometryMeasurement) {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));){
            out.println("# deisotoped by fbdm algorithm at " + new SimpleDateFormat("yyyy-MM-dd:HH-mm").format(new Date()));
            out.println("COM=" + massSpectrometryMeasurement.getSource());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    private static void writeLocal(File fileName, MassSpecMeasure massSpectrometryMeasurement) {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));){
            for (MassSpectrum MS : massSpectrometryMeasurement.getMSlist()) {
                out.println("BEGIN IONS");
                out.println("PEPMASS=" + MS.getPeptideMass());
                out.println("CHARGE=" + MS.getChargeState() + "+");
                int i = 0;
                for (i = 0; i < MS.getMz().size(); ++i) {
                    out.println(MS.getMz().get(i) + " " + MS.getIntensity().get(i));
                }
                out.println("END IONS");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    private static void writeConnect(File fileName, MassSpecMeasure massSpectrometryMeasurement) {
        WriteMGF.writeHeader(fileName, massSpectrometryMeasurement);
        WriteMGF.writeLocal(fileName, massSpectrometryMeasurement);
    }
}

