% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specificImputeMechanisms.R
\name{weighted_j2r}
\alias{weighted_j2r}
\title{Create a weighted_j2r \code{ImputeMechanism} object}
\usage{
weighted_j2r(trt.weight, delta = c(1, 1))
}
\arguments{
\item{trt.weight}{See details}

\item{delta}{If \code{trt.weight=1} then delta is a vector of length 2
(control.delta,treatment.delta) and the mean number of expected events for the imputed missing data is
multiplied by the appropriate delta}
}
\value{
An \code{ImputeMechanism} object
}
\description{
Missing counts for a subject in the active treatment arm will be imputed according to a point 
(determined by \code{trt.weight}) between the means of the placebo and treatment arms,
conditioned on the number of events. Missing counts for subjects in the 
placebo arm will be imputed according to the mean of the placebo arm, conditioned
on the subject's observed number of events.
}
\details{
If \code{trt.weight} = 0 then imputation using this mechanism will follow 
the jump to reference (j2r) model whereby missing counts for subjects 
in both arms will be imputed according to the mean of the placebo arm 
conditioned on the subject's observed number of events

If \code{trt.weight} = 1 then imputation using this mechanism will follow 
the MAR model whereby missing counts for subjects 
in each arm will be imputed according to the event rate of subjects in its treatment group 
conditioned on the subject's observed number of events

See the User guide vignette for further details
}
\examples{
sim <- SimulateComplete(study.time=365,number.subjects=50,
event.rates=c(0.01,0.005),dispersions=0.25)
sim.with.MCAR.dropout <- SimulateDropout(sim,
                     drop.mechanism = ConstantRateDrop(rate = 0.0025))
fit <- Simfit(sim.with.MCAR.dropout)
imps <- Impute(fit, weighted_j2r(trt.weight=0), 10)

}
\seealso{
\code{\link{ImputeMechanism.object}}
}
