% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{shape}
\alias{shape}
\title{The shape coefficient}
\usage{
shape(volume, height, dbh, basal = NULL)
}
\arguments{
\item{volume}{numeric, tree real volume.}

\item{height}{numeric, tree height.}

\item{dbh}{numeric, diameter at breast height (DBH).}

\item{basal}{numeric, basal area. Is used when \code{dbh} is not specified.}
}
\value{
The shape coefficient.
}
\description{
The shape coefficient of the tree is the ratio of the actual
volume of the tree to the volume of a cylinder having as base the surface of
the section at 1.3 m (or a given breast height) and as length, the height of
the tree.
}
\examples{
shape(volume = 10000, 11, dbh = 40)
shape(volume = 10000, 11, 40)
shape(volume = 10000, 11, basal = 2256.637)
## Bellow gives warning
shape(volume = 10000, height = 11, dbh = 40, basal = 2256.637)
}
\seealso{
\code{\link{volume}}, for tree real volume.
}
