% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/denovolyze.R
\name{denovolyze}
\alias{denovolyze}
\alias{denovolyzeByClass}
\alias{denovolyzeByGene}
\title{Evaluates burden of \emph{de novo} variation against expectation}
\usage{
denovolyze(genes, classes, nsamples, groupBy = "class",
  includeGenes = "all", includeClasses = c("syn", "mis", "misD", "non",
  "stoploss", "startgain", "splice", "frameshift", "lof", "prot", "protD",
  "all"), geneId = "geneName", signifP = 3, roundExpected = 1,
  probTable = NULL, misD = NULL)

denovolyzeByClass(genes, classes, nsamples, groupBy = "class",
  includeGenes = "all", includeClasses = c("syn", "mis", "lof", "prot",
  "all"), geneId = "geneName", signifP = 3, roundExpected = 1,
  probTable = NULL)

denovolyzeByGene(genes, classes, nsamples, groupBy = "gene",
  includeGenes = "all", includeClasses = c("lof", "prot"),
  geneId = "geneName", signifP = 3, roundExpected = 1, probTable = NULL)
}
\arguments{
\item{genes}{A vector of genes containing de novo variants.}

\item{classes}{A vector of classes of de novo variants.  Standard supported
classes are "syn" (synonymous), "mis" (missense), "non" (nonsense),
"splice" (splice), "frameshift" (frameshift) and "lof" (loss of function =
non + splice + frameshift). Additional classes that are supported by the
code, but are not included in the built-in probability tables, are
"stoploss","startloss", "misD" (damaging missense).  These labels may be
used for user-supplied probability tables. If "misD" is present, then "mis"
(in the input) implies non-damaging missense.}

\item{nsamples}{Number of individuals considered in de novo analysis.}

\item{groupBy}{Results can be tabulated by "gene", or by variant "class"}

\item{includeGenes}{Genes to include in analysis. "all" or a vector of gene
names.}

\item{includeClasses}{Determines which variant classes are tabulated in
output.  In addition to the input classes, summaries can be produced for
"prot" (protein-altering = mis + lof), "all", and "protD" (protein damaging
= misD + lof, only available if misD included in user-specified probability
table).  If "misD" is present, then "mis" will return statistics for all
missense.  Non-damaging missense are not analysed separately.}

\item{geneId}{Gene identifier used. One of "hgncID", "hgncSymbol",
"enstID", "ensgID" or "geneName" (default, equals ensembl "external_gene_name")}

\item{signifP}{Number of significant figures used to round p-values in
output.}

\item{roundExpected}{Number of decimal places used to round expected burdens
in output.}

\item{probTable}{Probability table. A user-defined table of probabilities can
be provided here, to replace the probability table included in the package.}

\item{misD}{If the user-specified probability table contains probabilities
  for a sub-category of missense variants (e.g. predicted to be damaging by
  an in silico algorithm), this column should be called misD, or the
  alternative name should be specified here.}
}
\value{
Returns a data frame
}
\description{
Determines whether the test population carry more \emph{de novo} variants
than expected. Variants may be grouped by variant class (e.g. are there more
LOF variants than expected, across the whole dataset?), or by gene (are there
more variants of a given class in SCN2A?).
}
\details{
Analyses can be restricted to a subset of genes, and/or a subset of variant
classes

See vignette("denovolyzeR_intro") for more information.
}
\section{Functions}{
\itemize{
\item \code{denovolyzeByClass}: denovolyzeByClass

\item \code{denovolyzeByGene}: denovolyzeByGene
}}
\examples{
### denovolyze

denovolyze(genes=autismDeNovos$gene,
           classes=autismDeNovos$class,
           nsamples=1078)

### denovolyzeByClass

denovolyzeByClass(genes=autismDeNovos$gene,
                  classes=autismDeNovos$class,
                  nsamples=1078)

# this convenience function is identical to:

denovolyze(genes=autismDeNovos$gene,
           classes=autismDeNovos$class,
           nsamples=1078,
           groupBy="class",
           includeClasses=c("syn","mis","lof","prot","all"),
           includeGenes="all"
           )

### denovolyzeByGene

denovolyzeByGene(genes=autismDeNovos$gene,
                 classes=autismDeNovos$class,
                 nsamples=1078)

# this is identical to:

denovolyze(genes=autismDeNovos$gene,
           classes=autismDeNovos$class,
           nsamples=1078,
           groupBy="gene",
           includeClasses=c("lof","prot"),
           includeGenes="all"
           )
}

